#include <bits/stdc++.h>
using namespace std;

const int N = 300005;
vector<pair<int, char>> graph[N];
int n;

int Sdfs(int v, int p, int cnto, int cnti){
    if(cnti == 1 && cnto == 1)
        return 1;
    if(cnti > 1 || cnto > 1)
        return 0;
    if(graph[v].size() == 1)
        return 0;
    int res = 0;
    for(auto u : graph[v]){
        if(u.first == p || u.second == 'S')
            continue;
        res += Sdfs(u.first, p, cnto + (u.second == 'O'), cnti + (u.second == 'I'));
    }
    return res;
}

void solveS(int sx, int sy){
    int res = 0;
    res += Sdfs(sx, sy, 0, 0);
    res += Sdfs(sy, sx, 0, 0);
    int sxo = 0, sxi = 0, syo = 0, syi = 0;
    for(auto u : graph[sx]){
        if(u.second == 'O'){
            sxo++;
        }else if(u.second == 'I'){
            sxi++;
        }
    }
    for(auto u : graph[sy]){
        if(u.second == 'O'){
            syo++;
        }else if(u.second == 'I'){
            syi++;
        }
    }
    res += sxo * syi + sxi * syo;
    cout << res << "\n";
}

int res1 = 0;
void dfsSmol(int v, int p, int cnts, int cnto, int cnti){
    if(p != -1 && cnts == cnto && cnto == cnti)
        res1++;
    for(auto u : graph[v]){
        if(u.first == p)
            continue;
        dfsSmol(u.first, v, cnts + (u.second == 'S'), cnto + (u.second == 'O'), cnti + (u.second == 'I'));
    }
}

void smol(){
    for(int i = 1; i <= n; ++i){
        dfsSmol(i, -1, 0, 0, 0);
    }
    res1 /= 2;
    cout << res1 << "\n";
}

map<pair<int, pair<int, int>>, int> mp; //{s,{i,o}}

void path(){
    mp[{0,{0,0}}]++;

    long long res = 0;
    int cnts = 0, cnto = 0, cnti = 0;
    for(int i = 2; i <= n; ++i){
        char bVal;
        if(graph[i][0].first == i - 1)
            bVal = graph[i][0].second;
        else
            bVal = graph[i][1].second;

        cnts += (bVal == 'S');
        cnti += (bVal == 'I');
        cnto += (bVal == 'O');
        int mn = min(cnts, min(cnti, cnto));
        cnts -= mn;
        cnti -= mn;
        cnto -= mn;

        res += mp[{cnts,{cnti,cnto}}];
        mp[{cnts,{cnti,cnto}}]++;
    }

    cout << res << "\n";
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie();

    {
        int scount = 0;
        int sx, sy;
        cin >> n;
        for(int i = 0; i < n - 1; ++i){
            int x, y;
            char c;
            cin >> x >> y >> c;
            graph[x].push_back({y, c});
            graph[y].push_back({x, c});
            if(c == 'S'){
                scount++;
                sx = x;
                sy = y;
            }
        }

        if(scount == 1){
            solveS(sx, sy);
            return 0;
        }
    }

    if(n <= 1000){
        smol();
    }else{
        path();
    }
    return 0;
}
/*
sub1:
11
1 3 O
3 2 O
3 4 S
4 10 O
10 8 I
8 9 I
4 11 I
11 5 I
6 11 O
7 11 O
--
5


sub3:
15
1 2 S
2 3 I
3 4 O
4 5 I
5 6 I
6 7 O
7 8 S
8 9 S
9 10 O
10 11 I
11 12 I
12 13 O
13 14 S
14 15 S
---
14
*/